/* COPYRIGHT 2000 by 3rd-evolution
 * Author: Thomas Krammer (tkrammer@3rd-evolution.de)
 */

#include "pch.h"
#include "FlickerFreeButton.h"

CFlickerFreeButton::CFlickerFreeButton(BRect frame,
	const char *name,
	const char *label,
	BMessage *message,
	uint32 resizingMode,
	uint32 flags) :
	BButton(frame, name, label, message, resizingMode,
		flags | B_FRAME_EVENTS)
{
	bgColor = CColor::Black;
}

void CFlickerFreeButton::AttachedToWindow()
{
	if(Parent())
		bgColor = Parent()->ViewColor();
		
	SetViewColor(CColor::Transparent);
}

void CFlickerFreeButton::Draw(BRect updateRect)
{
	SetLowColor(bgColor);
	StrokeRect(updateRect, B_SOLID_LOW);
	BButton::Draw(updateRect);
}

void CFlickerFreeButton::FrameResized(float width, float height)
{
	Draw(BRect(0, 0, width, height));
	BButton::FrameResized(width, height);
}
