/* COPYRIGHT 2000 by 3rd-evolution
 * Author: Thomas Krammer (tkrammer@3rd-evolution.de)
 */

#ifndef SERIAL_DISPLAY_H
#define SERIAL_DISPLAY_H

#include <device/SerialPort.h>

int32 data_rate_in_bps(data_rate dataRate);

class ISerialDisplay
{
	public:
	ISerialDisplay() {}
	virtual ~ISerialDisplay() {}
	
	virtual status_t Init(int32 port) = 0;
	virtual status_t Init(const char *deviceName) = 0;
	virtual status_t InitCheck() = 0;
	
	virtual void AutoWrap(bool enable) = 0;
	virtual void AutoScroll(bool enable) = 0;
	virtual void Cursor(bool enable, bool blink) = 0;
	virtual void Backlight(bool enable) = 0;
	virtual void Clear() = 0;
	virtual void Home() = 0;
	
	// Display the string 'str' at the current cursor position.
	virtual void DisplayString(const char *str) = 0;
	// Display the string 'str' at the postion (x,y)
	virtual void DisplayString(const char *str, int8 x, int8 y) = 0;
	// Display the first 'len' bytes of 'str' at postion (x,y)
	virtual void DisplayString(const char *str, int8 x, int8 y, int8 len) = 0;
	// Move cursor to (x,y)
	virtual void CursorTo(int8 x, int8 y) = 0;
	
	// Write a block of raw-data to the display.
	virtual void Write(const char *data, int32 len) = 0;
	
	virtual void InitHorizontalBarGraph() = 0;
	virtual void InitVerticalBarGraph() = 0;
	virtual void InitThinVerticalBarGraph() = 0;
	
	virtual void DrawVerticalBar(int8 column, int8 length) = 0;
	virtual void DrawHorizontalBar(int8 column, int8 row, bool rightToLeft, int8 length) = 0;
	
	virtual BSerialPort *Port() = 0;
};

class CMatrixOrbitalSerialDisplay : public ISerialDisplay
{
	public:
	CMatrixOrbitalSerialDisplay();
	virtual ~CMatrixOrbitalSerialDisplay();

	virtual status_t Init(int32 port);
	virtual status_t Init(const char *deviceName);
	virtual status_t InitCheck() { return initResult; }

	virtual void AutoWrap(bool enable);
	virtual void AutoScroll(bool enable);
	virtual void Cursor(bool enable, bool blink);
	virtual void Backlight(bool enable);
	virtual void Clear();
	virtual void Home();
	virtual void DisplayString(const char *str);
	virtual void DisplayString(const char *str, int8 x, int8 y);
	virtual void DisplayString(const char *str, int8 x, int8 y, int8 len);
	virtual void CursorTo(int8 x, int8 y);

	virtual void Write(const char *data, int32 len);
	
	virtual void InitHorizontalBarGraph();
	virtual void InitVerticalBarGraph();
	virtual void InitThinVerticalBarGraph();
	
	virtual void DrawVerticalBar(int8 column, int8 length);
	virtual void DrawHorizontalBar(int8 column, int8 row, bool rightToLeft, int8 length);
	
	virtual BSerialPort *Port() { return serial; }
	
	protected:
	status_t CommonInit();
	
	status_t initResult;
	BSerialPort *serial;
};

#endif // SERIAL_DISPLAY_H